from fastapi import APIRouter, Depends
from datetime import datetime
from typing import Optional

from app.db import database
from app.v1.models.platform.geofence_rule_mapping import (
    GeofenceRuleMapping, GeofenceRuleMappingCreate,
    GeofenceRuleMappingUpdate, GeofenceRuleMappings
)
from app.v1.services.platform.geofence_rule_mapping import (
    create_mapping_service, get_mapping_service,
    update_mapping_service, delete_mapping_service,
    list_mappings_service
)

router = APIRouter()

@router.post("/", response_model=GeofenceRuleMapping)
async def create_mapping(data: GeofenceRuleMappingCreate, db=Depends(database.get_mongo_db)):
    return await create_mapping_service(data, db)

# @router.get("/", response_model=GeofenceRuleMappings)
# async def list_mappings(skip: int = 0, limit: int = 10, db=Depends(database.get_mongo_db)):
#     print('SSSSSSSSSSSSSSSSSSSSSSSSSSSS')
#     return await list_mappings_service(skip, limit, db)

@router.get("/", response_model=GeofenceRuleMappings)
async def list_mappings(
    account_id: str,
    skip: int = 0,
    limit: int = 10,
    db=Depends(database.get_mongo_db)
):
    return list_mappings_service(account_id, skip, limit, db)


@router.get("/{account_id}", response_model=GeofenceRuleMappingCreate)
async def get_mapping(account_id: str, db=Depends(database.get_mongo_db)):
    return await get_mapping_service(account_id, db)

@router.post("/{account_id}", response_model=GeofenceRuleMapping)
async def post_mapping(account_id: str, data: GeofenceRuleMappingCreate, db=Depends(database.get_mongo_db)):
    return await create_mapping_service(data, db)

@router.delete("/{account_id}", response_model=GeofenceRuleMapping)
async def delete_mapping(account_id: str, db=Depends(database.get_mongo_db)):
    return await delete_mapping_service(account_id, db)

@router.put("/{account_id}", response_model=GeofenceRuleMapping)
async def update_mapping(account_id: str, update: GeofenceRuleMappingUpdate, db=Depends(database.get_mongo_db)):
    return await update_mapping_service(account_id, update, db)
